/*
 * Decompiled with CFR 0.152.
 */
package com.mckoi.util;

import com.mckoi.util.SearchResults;
import java.util.Arrays;

public final class SortUtil {
    public static void quickSort(Comparable[] list, int min, int max) {
        Arrays.sort(list, min, max + 1);
    }

    public static void quickSort(Comparable[] obs) {
        SortUtil.quickSort(obs, 0, obs.length - 1);
    }

    public static int sortedIndexOf(Comparable[] list, Comparable val, int lower, int higher) {
        if (lower >= higher) {
            if (val.compareTo(list[lower]) > 0) {
                return lower + 1;
            }
            return lower;
        }
        int mid = (lower + higher) / 2;
        Comparable mid_val = list[mid];
        if (val.equals(mid_val)) {
            return mid;
        }
        if (val.compareTo(mid_val) < 0) {
            return SortUtil.sortedIndexOf(list, val, lower, mid - 1);
        }
        return SortUtil.sortedIndexOf(list, val, mid + 1, higher);
    }

    public static SearchResults sortedQuickFind(Comparable[] list, Comparable val, SearchResults results) {
        int temp_i;
        if (list.length == 0) {
            return null;
        }
        int size = list.length - 1;
        int count = 0;
        int i = SortUtil.sortedIndexOf(list, val, 0, size);
        if (i > size) {
            return null;
        }
        for (temp_i = i; temp_i >= 0 && list[temp_i].equals(val); --temp_i) {
            ++count;
        }
        int start_index = temp_i + 1;
        for (temp_i = i + 1; temp_i <= size && list[temp_i].equals(val); ++temp_i) {
            ++count;
        }
        if (count == 0) {
            return null;
        }
        if (results == null) {
            results = new SearchResults();
        }
        results.found_index = start_index;
        results.found_count = count;
        return results;
    }
}

